function [] = psshapeblur(r, s)
%PSSHAPEBLUR    Run the Shape Blur filter.
%   PSSHAPEBLUR runs the filter with the default parameters.
%
%   PSSHAPEBLUR(R,S) R for radius in pixels ranging from 5 -> 10000,
%   default is 10. S for shape as a string.
%
%   Example:
%   psshapeblur
%   psshapeblur(12, 'Banner 3')
%
%   See also PSADDNOISE, PSAVERAGE, PSBLUR, PSBLURMORE, PSBOXBLUR,
%   PSCUSTOM, PSDUSTANDSCRATCHES, PSGAUSSIANBLUR, PSHIGHPASS, PSLENSBLUR,
%   PSMAXIMUM, PSMEDIAN, PSMINIMUM, PSMOTIONBLUR, PSOFFSET, PSRADIALBLUR,
%   PSSHARPEN, PSSHARPENEDGES, PSSHARPENMORE, PSSMARTBLUR, PSSURFACEBLUR,
%   PSUNSHARPMASK

%   Thomas Ruark, 2/3/2006
%   Copyright 2006 Adobe Systems Incorporated

if nargin < 1
    r = 10;
end
if nargin < 2
    s = '';
else
    s = ['var id25 = stringIDToTypeID( "customShape" );' ...
        'var desc5 = new ActionDescriptor();' ...
        'var id26 = charIDToTypeID( "Nm  " );' ...
        'desc5.putString( id26, "' s '");' ...
        'desc4.putObject( id25, id25, desc5 );' ...
        ];
end

% Build up the JavaScript
pstext = ['var b = "";' ...
    'try { ' ...
    '    var id22 = stringIDToTypeID( "shapeBlur" );' ...
    '    var desc4 = new ActionDescriptor();' ...
    '    var id23 = charIDToTypeID( "Rds " );' ...
    '    var id24 = charIDToTypeID( "#Pxl" );' ...
    '    desc4.putUnitDouble( id23, id24, ' num2str(r) ');' ...
    '    ' s ' ' ...
    '    executeAction( id22, desc4, DialogModes.NO );' ...
    '    b = "OK";' ...
    '}' ...
    'catch(e) { ' ...
    '    b = e.toString();' ...
    '}' ...
    'b;'];

psresult = psjavascriptu(pstext);

if ~strcmp(psresult, 'OK')
    error(psresult);
end
